<?php
#   Copyright by Manuel Staechele
#   Support www.ilch.de


defined ('main') or die ( 'no direct access' );

# include other functions
require_once('include/includes/function/debug.php');
require_once('include/includes/function/identification.php');
require_once('include/includes/function/has_admin_right.php');
require_once('include/includes/function/bbcode.php');
require_once('include/includes/function/check_rights.php');
require_once('include/includes/function/check_forum_failure.php');
require_once('include/includes/function/profilefields.php');
require_once('include/includes/function/statistic.php');
require_once('include/includes/function/get_m.php');

function getFuerAr () {
  $ar = array
	(
		   '0' => 'Alle',
			'-1' => 'User',
			'-2' => 'Trial',
			'-3' => 'Member',
			'-4' => 'Leader',
  		'-5' => 'Admin'
	);
  return ($ar);
}

function get_user_rights () {
  $ar = array
	(
			'-1' => 'User',
			'-2' => 'Trial',
			'-3' => 'Member',
			'-4' => 'Leader',
  		'-5' => 'Admin'
	);
  return ($ar);
}

function groups_fuer_array () {
  $ar1 = groups_array();
	$ar1[-4] = 'Leader';
	$ar1[-3] = 'Member';
	$ar1[-2] = 'Trial';
	$ar1[-1] = 'User';
	$ar1[0] = 'Alle';
	return ($ar1);
}

function groups_array () {
	$ar = array(-5 => 'keine Gruppe');
	$erg = db_query("SELECT id,name FROM prefix_groups ORDER BY id");
	while($row = db_fetch_row($erg) ) {
	  $ar[$row[0]] = ' '.$row[1];
	}
	return($ar);
}

function getmods ($gid,$db) {

	$erg = db_query("SELECT b.id,b.name FROM prefix_groupusers a LEFT JOIN prefix_user b ON b.id = a.uid WHERE a.gid = ".$gid);
	if ( db_num_rows($erg) > 0 ) {
	  $mods = '<br /><u>Moderators:</u> ';
	  while($row = db_fetch_object($erg) ) {
		  $mods .= '<a class="smalfont" href="?m=user&um=6&uid='.$row->id.'">'.$row->name.'</a>, ';
	  }
		$mods = substr ( $mods , 0 , strlen ( $mods ) - 2 );
		return ($mods);
	} else {
	  return ('');
	}
}

function get_ordner ( $ftime ) {
	if ( $ftime >= $_SESSION['lastlogin'] ) {
	  return ('nord');
	} else {
	  return ('ord');
	}
}

##
###
####
#####  W E I T E R L E I T U N G S   F U N K T I O N
function wd ($wdLINK,$wdTEXT,$wdZEIT=3) {
	if (!is_array($wdLINK ) ) {
	  $urls  = '<a href="'.$wdLINK.'">weiter</a>';
	  $wdURL = $wdLINK;
	} else {
	  $urls  = '';
    $i = 0;
		foreach($wdLINK as $k => $v) {
		  if ( $i == 0 ) {
			  $wdURL = $v;
			}
			$urls .= '<a href="'.$v.'">'.$k.'</a><br />';
		  $i++;
		}
	}
	$tpl = new tpl ( 'weiterleitung.htm' );
	$ar = array
	(
    'LINK' => $urls,
	  'URL'  => $wdURL,
		'ZEIT' => $wdZEIT,
		'TEXT' => $wdTEXT
	);
	$tpl->set_ar_out ( $ar, 0 );
	unset($tpl);
}


##
###
####
##### g e t   R e c h t
function getrecht ($RECHT, $USERRECHT) {
	if ( empty ( $USERRECHT ) ) {
	  return (false);
	} else {
	  if($USERRECHT <= $RECHT) {
	    return (true);
	  } else {
	    return (false);
	  }
  }
}

##
###
####
##### g e t   U s e r   N a m e
function get_n($uid) {

  global $db;
	$row = db_fetch_object(db_query("SELECT name FROM prefix_user WHERE id = '".$uid."'"));
	return $row->name;
}

##
###
####
##### wochentage sonntag 0 samstag 6
function wtage ($tag) {
  $wtage = array('Sonntag','Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag');
  return ($wtage[$tag]);
}

##
###
####
##### monate in deutsch
function getDmon ($mon) {
  $monate = array('Januar','Februar','M&auml;rz','April','Mai','Juni','Juli','August','September','Oktober','November','Dezember');
  return($monate[$mon-1]);
}


##
###
####
##### a l l g e m e i n e s   A r r a y
function getAllgAr () {

	# v1 = schl�ssel
	# v2 = wert
	# v3 = feldtyp
  # v4 = kurze beschreibung wenn n�tig

	global $db;
	$ar = array();
	$abf = 'SELECT * FROM `prefix_allg` WHERE k = "ALLG"';
	$erg = db_query($abf);
	while($row = db_fetch_object($erg) ) {
	  $ar[$row->v1] = $row->v2;
	}
	return $ar;
}

##
###
####
##### UserRang ermitteln
function userrang ($post) {
	$post = ( $post == 0 ? 1 : $post );
	$rangt=@db_result(db_query("SELECT bez FROM `prefix_ranks` WHERE spez = 0 AND min <= ".$post." ORDER BY min DESC LIMIT 1"),0);
	$rRang = $rangt;
	return ($rRang);
}

function rangbild ($post) {
	$post = ( $post == 0 ? 1 : $post );
	$rangt=@db_result(db_query("SELECT bez FROM `prefix_ranks` WHERE spez = 0 AND min <= ".$post." ORDER BY min DESC LIMIT 1"),0);
	if(file_exists('include/images/ranks/'.$rangt.'.gif')){
	$rRang.= '<br><img src="include/images/ranks/'.$rangt.'.gif" alt="'.$rangt.'" border="0">';
	} else {
	$rRang = '<br>'.$rangt;
	}

	return ($rRang);
}
function rangbildforum ($post) {
	$post = ( $post == 0 ? 1 : $post );
	$rangt=@db_result(db_query("SELECT bez FROM `prefix_ranks` WHERE spez = 0 AND min <= ".$post." ORDER BY min DESC LIMIT 1"),0);
	if(file_exists('include/images/ranks/'.$rangt.'.gif')){
	$rRang.= '<img src="include/images/ranks/'.$rangt.'.gif" alt="'.$rangt.'" width="40" height="40" border="0">';
	} else {
	$rRang = '<br>'.$rangt;
	}

	return ($rRang);
}


##
###
####
##### makiert suchwoerter
function  markword($text,$such) {
  $erg  = '<span style="background-color: #EBF09B;">';
  $erg .= $such."</span>";
	$text = str_replace($such,$erg,$text);
  return $text;
}


##
###
####
##### gibt die smiley lilste zurueck
function getsmilies () {
  $zeilen = 3; $i = 0;
	$a = '<table width="100%" border="0" cellspacing="0" cellpadding="0">';
  $erg = db_query('SELECT * FROM `prefix_smilies`');
	while ($row = db_fetch_object($erg) ) {
    if($i%$zeilen == 0) { $a .= '<tr>'; }
		$a .= '<td width="33%" height="25" align="center">';
		$a .= '<a href="#" onClick="javascript:put(\''.$row->ent.'\')">';
    $a .= '<img src="'.$row->url.'" border="0"></a></td>';
    if($i%$zeilen == $zeilen-1)  {  $a .= '</tr>';  } $i++;
	}
	$a .= '</table>';
  return $a;
}



##
###
####
##### generey key with x length
function genkey ( $anz ) {
	$letterArray = array ('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','1','2','3','4','5','6','7','8','9','0','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','1','2','3','4','5','6','7','8','9','0');
  $key = '';
	for ($i=0;$i < $anz ; $i ++)
	{
	    mt_srand((double)microtime()*1000000);
	    $zufallZahl = mt_rand(0,62);
      $key .= $letterArray[$zufallZahl];
  }
	return ( $key );
}


function dbliste ($aka, $tpl, $n, $q) {
  $l = '';
	$e = db_query($q);
	while($r = db_fetch_row($e) ) {
	  $s = ( $aka == $r[0] ? ' selected' : '' );
		$l .= $tpl->list_get($n, array ($s,$r[0],$r[1]));
	}
	return ($l);
}

function dblistee ($aka, $q) {
  $l = '';
	$e = db_query($q);
	while($r = db_fetch_row($e) ) {
	  $s = ( $aka == $r[0] ? ' selected' : '' );
		$l .= '<option value="'.$r[0].'"'.$s.'>'.$r[1].'</option>';
	}
	return ($l);
}

function arliste ( $aka , $ar , $tpl , $n ) {
  $l = '';
	foreach($ar as $k => $v) {
	  $s = ( $aka == $k ? ' selected' : '' );
		$l .= $tpl->list_get($n, array($s,$k,$v));
	}
	return ($l);
}

function arlistee ( $aka , $ar  ) {
  $l = '';
	foreach($ar as $k => $v) {
	  $s = ( $aka == $k ? ' selected' : '' );
		$l .= '<option value="'.$k.'"'.$s.'>'.$v.'</option>';
	}
	return ($l);
}

function unescape ( $var ) {
  return ( stripslashes($var) );
}

function escape ($var, $type) {
  switch ( $type ) {
	  case 'string' :
			$var = str_replace('"',"'",$var);
			$var = strip_tags($var);
			$var = addslashes($var);
		break;
		case 'textarea' :
			$var = preg_replace("/<textarea .*>/si",'',$var);
			$var = str_replace('</textarea>','',$var);
			$var = addslashes($var);
			$type = 'string';
		break;
	}
	settype ( $var , $type );
  # integer, double, array, object
	return ( $var );
}


function icmail ($mail,$bet,$txt) {
  global $allgAr;
	if ( mail ( $mail, $bet, $txt,"From: Automatische eMail <".$allgAr['adminMail'].">") ) {
	  return ( true );
	} else {
	  return ( false );
	}
}
?>